#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));
const int N = 111;
const int M = 1010;
const int iters = 60;

struct edge {

	int go;
	double f, c;

};

int k;
pii e[M];
int first[N], deg[N], q[N], used[N], pv[N], pe[N];
edge p[4 * M + 4 * N];
int next[4 * M + 4 * N];

inline void add(int a, int b, double c) {
	p[++k].go = b;
	p[k].c = c;
	p[k].f = 0;
	next[k] = first[a];
	first[a] = k;

	p[++k].go = a;
	p[k].f = p[k].c = 0;
	next[k] = first[b];
	first[b] = k;
}

inline void gen() {
	freopen("H2.in", "w", stdout);
	cout << 100 << " " << 1000 << endl;
	for (int i = 0; i < 1000; ++i) {
		cout << 1 + rand() % 100 << " " << 1 + rand() % 100 << endl;
	}
	exit(0);
}

int main() {
	//gen();
#ifdef LOCAL42
#define TASK "H"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	int n, m;
	scanf("%d %d", &n, &m);
	for (int i = 0; i < m; ++i) {
		scanf("%d %d", &e[i].fs, &e[i].sc);
		--e[i].fs;
		--e[i].sc;
		++deg[e[i].fs];
		++deg[e[i].sc];
	}
	double l = 0, r = n;
	int step = 0;
	for (int it = 0; it < iters; ++it) {
		double mid = (l + r) / 2;
		int s = n, t = n + 1;
		k = 0;
		for (int i = 0; i <= t; ++i) {
			first[i] = 0;
		}
		for (int i = 0; i < m; ++i) {
			add(e[i].fs, e[i].sc, 1);
			add(e[i].sc, e[i].fs, 1);
		}
		for (int i = 0; i < n; ++i) {
			add(s, i, deg[i]);
			add(i, t, 2 * mid);
		}
		double flow = 0;
		for (;;) {
			++step;
			used[s] = step;
			int l = 0, r = 1;
			q[0] = s;
			while (l < r && used[t] != step) {
				int v = q[l++];
				for (int i = first[v]; i > 0 && used[t] != step; i = next[i]) {
					if (p[i].c - p[i].f > 0 && used[p[i].go] != step) {
						used[p[i].go] = step;
						pv[p[i].go] = v;
						pe[p[i].go] = i;
						q[r++] = p[i].go;
					}
				}
			}
			if (used[t] != step) {
				break;
			}
			double can = inf;
			for (int i = t; i != s; i = pv[i]) {
				can = min(can, p[pe[i]].c - p[pe[i]].f);
			}
			flow += can;
			for (int i = t; i != s; i = pv[i]) {
				p[pe[i]].f += can;
				if (pe[i] % 2 == 0) {
					p[pe[i] - 1].f -= can;
				} else {
					p[pe[i] + 1].f -= can;
				}
			}
		}
		if (2 * m - flow > eps) {
			l = mid;
		} else {
			r = mid;
		}
	}
	vi ans;
	for (int i = 0; i < n; ++i) {
		if (used[i] == step) {
			ans.pb(i);
		}
	}
	if (sz(ans) == 0) {
		ans.pb(0);
	}
	printf("%d\n", sz(ans));
	for (int i = 0; i < sz(ans); ++i) {
		printf("%d\n", ans[i] + 1);
	}
	eprintf("%.19lf\n", 1.0 * clock() / CLOCKS_PER_SEC);
	return 0;
}
